<?php

/**
 * @package     Joomla ColorPicker Element
 * @author      Markus Bopp
 * @link        http://www.crosstec.de
 * @license     GNU/GPL
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldColorpicker extends JFormField {

    protected $type = 'Colorpicker';

    protected function getInput() {

        JHTML::_('behavior.modal');

        JFactory::getDocument()->addStyleSheet(JURI::root(true) . '/modules/mod_responsive_slideshow/tmpl/js/colorpicker/css/colorpicker.css');
        JFactory::getDocument()->addScript(JURI::root(true) . '/modules/mod_responsive_slideshow/tmpl/js/jquery.min.js');
        JFactory::getDocument()->addScript(JURI::root(true) . '/modules/mod_responsive_slideshow/tmpl/js/colorpicker/js/colorpicker.js');

        $out = '<script type="text/javascript">
jQuery("#' . $this->id . '").ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.bind("keyup", function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
</script>
';

        return '<input type="text" name="' . $this->name . '" id="' . $this->id . '" value="' . $this->value . '"/>' . $out;
    }

}